<?php if(!isset($portal)) die();?>
<!DOCTYPE html>
<html>
  <head>
    <meta charset="utf-8">
    <link rel="stylesheet" type="text/css" href="css/style.css">
    <title>Portal</title>
  </head>
  <body>
  
    <div id="topDiv" class="scafoldingDiv">
      <div id="headerMainDiv">
        Nagłówek strony
      </div>
      <div id="headerUserInfoDiv">
        <?php if($portal->zalogowany): ?>
          <div>Jesteś zalogowany jako: <?=$portal->zalogowany?></div>
          <div><a href="index.php?action=logout">Wylogowanie</a></div>
        <?php else: ?>
          <div>Nie jesteś zalogowany.</div>
          <div><a href="index.php?action=showLoginForm">Logowanie</a></div>
        <?php endif ?>
      </div>
    </div>
    
    <div id="mainContentDiv" class="scafoldingDiv">
      <?php
        switch($action):
          case 'showLoginForm' :
            include 'templates/loginForm.php';
            break;
          case 'showFullStats' :
            echo $portal->getFullStats();
            include 'templates/statsForm.php';
            break;
          case 'showMain':
          default:
            include 'templates/innerContentDiv.php';
        endswitch;
      ?>
    </div>
    
    <div id="footerDiv" class="scafoldingDiv">
      <div>
        <?php if($stats = $portal->getShortStats($timeout)):?>
          W ciągu ostatnich <?=$stats['timeout']?> minut stronę odwiedziło
          <?=$stats['allUsers']?> gości, w tym <?=$stats['regUsers']?> 
          zarejestrowanych użytkowników.
        <?php else:?>
          Statystyki nie są dostępne.
        <?php endif;?>
      </div>
      <div>Zobacz pozostałe
        <a href="index.php?action=showFullStats">statystyki</a>.</div>
    </div>
    
  </body>
</html>
